global files "C:/Users/WB326023/Dropbox/WB/BPEA/BPEA Replication/"
global BPEAraw "$files/dataraw"
global BPEAout "$files/dataout"
global BPEAtemp "$files/temp"
global BPEAplots "$files/plots"

* colour blind friendly colours
global cblue "0 114 178"
global cred "213 94 0"
global corange "230 159 0"
global cyellow "240 228 66"
global cgreen "0 158 115"
global cblack "0 0 0"
global cpurple "204 121 167"
global cskyblue "86 180 233"

global graphsettings graphregion(color(white)) bgcolor(white) ylabel(, grid glcolor(gs15)) 


// plot
// american uncertainty - scatter
use "$BPEAout/us_trade/usa_unfriendly_countries.dta", clear
keep if import_share>=0.1 & !missing(import_share)

* normalize by China's import totals, then take logs
gen chn_share = import_goods_value if countrycode=="CHN"
egen chn = max(chn_share)
gen import_norm = import_goods_value/chn
gen log_imshare_norm = log(import_norm)
drop chn_share chn

* regress  friendly_sum import_norm
* regress  friendly_sum log_imshare
* regress log_imshare friendly_sum
* get import share by country

//log using "$BPEAplots/vf/datasets/vf_fig5_friendship_scatter.log", replace
regress friendly_sum log_imshare_norm
regress log_imshare_norm friendly_sum
//log close
twoway 	(lfit friendly_sum log_imshare_norm, lcolor(maroon) lpattern(dash)) || ///
		(scatter friendly_sum log_imshare_norm, mlab(countrycode) mlabcolor(black) m(i) mlabposition(0)),  ///
		$graphsettings ///
		xlabel(`=log(1)' "1" `=log(1/4)' "1/4"  ///
				`=log(1/16)' "1/16" `=log(1/64)' "1/64" ) ///
		xscale(r(-5.3 0)) ///
		ytitle("Percent of Americans believing country is friend or ally") ///
		xtitle("Percent of U.S. imports (normalized, CHN = 1)") ///
 		ylabel(0(20)100) leg(off) scale(0.8) 
		
graph save "$BPEAout/v2_graphs/vf_fig5_friendship_scatter.gph", replace
graph export "$BPEAplots/vf/pdf/vf_fig5_friendship_scatter.pdf", replace
graph export "$BPEAplots/vf/png/vf_fig5_friendship_scatter.png", replace
graph export "$BPEAplots/vf/eps/vf_fig5_friendship_scatter.eps", replace
local call

// end of code

/*
* get import share 
preserve	
	// imports 
	use "$BPEAout/goods/h0_import_goods_cc_level.dta", clear
	keep if reporteriso3=="USA"
	keep if year >= 2019
	drop if inlist(partneriso3, "WLD", "EUN")
	drop if inlist(reporteriso3, "WLD", "EUN")
	egen total_imports = sum(import_goods_value), by(year)
	collapse (sum) import_goods_value, by(partneriso3 year total_imports)
	gen import_share = import_goods_value/total_imports
	drop if missing(partneriso3)
	sort partneriso3 year
	egen imshare_rank = rank(-import_share), by(year)
	keep if year == 2021
	sort imshare_rank
	rename partneriso3 countrycode
	save "$BPEAtemp/importers_USA.dta", replace
restore 
*/